// random.h: random-number facilities for the CSC 270 simulation example
// -- J. Clarke, March-June 1996

#include "porting.h"

class randStream {
// Manage one stream of random numbers.
//
// "nextrand" gives the floating-point number obtained from a
// new value in this stream. "xsubi" stores that latest value.

private:
	unsigned short xsubi[3];

public:
	randStream (unsigned);
	randStream (void);
    // restart stream with seed S
	void setseed (unsigned long S);
    // return a random "unprocessed" long
	long nextraw (void);
    // return a random double between 0 and 1
	double nextfloat (void);
    // return a random long between lo and hi
	long nextint (long lo, long hi);
};

// Restart Stream with a new random seed.
extern void randomize (randStream *Stream);
