// depart.cc: departure events for the CSC 270 simulation example
// -- J. Clarke, March-June 1996

#include "event.h"
#include "evlist.h"
#include "car.h"
#include "carqueue.h"
#include "pump.h"
#include "pstand.h"
#include "stats.h"
#include "depart.h"
#include "globals.h"

// Which pump is this event connected to?

void departureClass::setPump (pumpClass * p)
{
	whichPump = p;
}

// The departure event routine

bool departureClass::makeItHappen (void)
{
	// pre whichPump not= NULL and whichPump -> carInService not= NULL

	// Identify the departing car and collect statistics.
	carClass * departingCar = whichPump -> carInService();
	stats -> accumSale (departingCar -> litresNeeded());

	// The car vanishes and the pump is free; can we serve another car?
	delete departingCar;
	if (carQueue->queueSize() > 0)
		whichPump -> startService (carQueue -> getNext());
	else
		pumpStand -> releasePump (whichPump);

	// This departure event is all done.
	delete this;

	return true; // Departures don't stop the simulation!
}
