// arrival.cc: arrival events for the CSC 270 simulation example
// -- J. Clarke, March-June 1996

#include "world.h"
#include "car.h"
#include "carqueue.h"
#include "pump.h"
#include "pstand.h"
#include "stats.h"
#include "event.h"
#include "evlist.h"
#include "arrival.h"
#include "globals.h"

// The car arrival event routine

bool arrivalClass::makeItHappen (void)
{
	// Create and initialize a new auto record
	carClass * arrivingCar = new carClass;
	stats -> countArrival ();
	const double L = arrivingCar -> litresNeeded();
	if (DoesCarBalk (L, carQueue->queueSize())) {
		stats -> accumBalk (L);
		delete arrivingCar;
	}
	else {
		arrivingCar -> setTime (simulationTime);
		if (pumpStand -> existsAvailablePump()) {
			pumpClass * Pump = pumpStand -> getAvailablePump ();
			Pump -> startService (arrivingCar);
		}
		else
			carQueue -> insert (arrivingCar);
	}

	// schedule the next arrival, reusing the current event object
	setTime (simulationTime + interarrivalTime());
	eventList -> insert (this);

	return true; // Arrivals don't stop the simulation!
}
