// pump.cc: the pump class for the CSC 270 simulation example
// -- J. Clarke, March-June 1996

#include "world.h"
#include "event.h"
#include "evlist.h"
#include "car.h"
#include "carqueue.h"
#include "pump.h"
#include "pstand.h"
#include "stats.h"
#include "depart.h"
#include "globals.h"

// The start-of-service event routine:
// Connect the Car to this pump, and determine when the service will stop.

void pumpClass::startService (carClass * Car)
{
	// pre pumpStand -> existsAvailablePump();

	// Match the auto to an available pump
	localCarInService = Car;
	const double pumpTime = serviceTime (localCarInService->litresNeeded());

	// Collect statistics
	stats -> accumWaitingTime (simulationTime
		- localCarInService -> arrivalTime());
	stats -> accumServiceTime (pumpTime);

	// Schedule departure of car from this pump
	departureClass * Dep = new departureClass (simulationTime + pumpTime);
	Dep -> setPump (this);
	eventList -> insert (Dep);
}
