// pstand.cc: the pump-stand class for the CSC 270 simulation example
// -- J. Clarke, March-June 1996
//
// The "pump stand" is the set of pumps at the service station.

#include <iostream.h>
#include "car.h"
#include "pump.h"
#include "pstand.h"

// Create set of available pumps and put all N pumps into it.

pumpStandClass::pumpStandClass (int N)
{
	if (N < 1) {
		cout << "Error! pump stand needs more than 0 pumps\n";
		return;
	}

	numPumps = N;
	pumps = new pumpListItem [N];
	topPump = N - 1;

	for (int j = 0; j < N; j++)
		pumps[j] = new pumpClass;
}

// Take a pump from the set of free pumps, and return a pointer to it.

pumpClass * pumpStandClass::getAvailablePump (void)
{
	if (topPump < 0) {
		cout << "Error! no pump available when needed\n";
		return NULL;
	}

	return pumps[topPump--];
}

// Put pump P back on the available list.
// P is set to NULL, just to cause trouble if the caller tries
// to reuse this pump, which is now officially free.

void pumpStandClass::releasePump (pumpClass *& P)
{
	if (topPump >= numPumps) {
		cout << "Error! attempt to release a free pump\n";
		return;
	}

	pumps[++topPump] = P;
	P = NULL;
}
