// event.h: the general event class for the CSC 270 simulation example
// -- J. Clarke, March-June 1996
//
// Specific events such as arrivals and departures inherit from
// this class. However, other events such as starts of service may
// not inherit; the difference is that start of service is never
// scheduled in advance but always provoked by an arrival or departure.

#include "porting.h"

class eventClass {
private:
	double localTime;

public:
	eventClass (double T = 0.0) {localTime = T;};
	inline double whatTime (void) {return localTime;}; // when it happens
	inline void setTime (const double newTime = 0) {localTime = newTime;};
	virtual bool makeItHappen (void) {return true;};
		// the event routine--returns false if simulation is finished.
};
