// stats.cc: statistics collection/display for the CSC 270 simulation example
// -- J. Clarke, March-June 1996

#include <stdio.h>
#include "event.h"
#include "evlist.h"
#include "car.h"
#include "carqueue.h"
#include "pump.h"
#include "pstand.h"
#include "stats.h"
#include "globals.h"

statsClass::statsClass (double P, double C)
{
	profit = P;
	cost = C;

	TotalArrivals = 0;
	customersServed = 0;
	balkingCustomers = 0;
	TotalLitresSold = 0.0;
	TotalLitresMissed = 0.0;
	TotalWaitingTime = 0.0;
	TotalServiceTime = 0.0;
}

void statsClass::accumSale (double litres)
{
	customersServed += 1;
	TotalLitresSold += litres;
}

void statsClass::accumBalk (double litres)
{
	balkingCustomers += 1;
	TotalLitresMissed += litres;
}

void statsClass::header (void)
{
        printf ("%9s%7s%8s%9s%8s%7s%9s%7s%8s%7s\n", " Current", "Total ",
                "NoQueue", "Car->Car", "Average", "Number", "Average", "Pump ",
                "Total", " Lost ");
        printf ("%9s%7s%8s%9s%8s%7s%9s%7s%8s%7s\n", "   Time ", "Cars ",
                "Fraction", "  Time  ", " Litres ", "Balked", "  Wait ",
                "Usage ", "Profit", "Profit");
        for (int i = 0; i < 79; i++)
                putchar ('-');
        putchar ('\n');
}

void statsClass::snapshot (void)
{
	printf("%8.0f%7i", simulationTime, TotalArrivals);
	printf("%8.3f", carQueue -> emptyTime()/simulationTime);
	if (TotalArrivals > 0) {
		printf("%9.3f%8.3f", simulationTime/TotalArrivals,
			(TotalLitresSold + TotalLitresMissed) / TotalArrivals);
	}
	else
		printf ("%9s%8s", "Unknown", "Unknown");

	printf ("%7i", balkingCustomers);
	if (customersServed > 0)
		printf ("%9.3f", TotalWaitingTime / customersServed);
	else
		printf ("%9s", "Unknown");
	printf ("%7.3f", TotalServiceTime
		/ (pumpStand -> howManyPumps() * simulationTime));
	printf ("%9.2f", TotalLitresSold * profit
		- cost * pumpStand -> howManyPumps());
	printf ("%7.2f\n", TotalLitresMissed * profit);
}
