--Names: John Doe, Jane Smith
--Login: jdoe, jsmith
--Email: jdoe@cs.ucr.edu, jsmith@cs.ucr.edu
--Lab Section: 0##
--Assignment: Lab #
--I acknowledge all content is original.

LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_arith.ALL;

ENTITY generic_subtractor_tb IS
END generic_subtractor_tb;
 
ARCHITECTURE behavior OF generic_subtractor_tb IS 
 
    -- Component Declaration for the Unit Under Test (UUT)
    COMPONENT generic_subtractor
    PORT(
         X : IN  std_logic_vector(31 downto 0);
         Y : IN  std_logic_vector(31 downto 0);
         D : OUT  std_logic_vector(31 downto 0);
         B : OUT  std_logic
        );
    END COMPONENT;
    
   --Inputs
   signal X : std_logic_vector(31 downto 0) := (others => '0');
   signal Y : std_logic_vector(31 downto 0) := (others => '0');

 	--Outputs
   signal D : std_logic_vector(31 downto 0);
   signal B : std_logic;
   
	--Clock
	signal clock : std_logic;
   constant clock_period : time := 10 ns;
 
BEGIN
 
	-- Instantiate the Unit Under Test (UUT)
   uut: generic_subtractor PORT MAP (
          X => X,
          Y => Y,
          D => D,
          B => B
        );

   -- Clock process definitions
   clock_process :process
   begin
		clock <= '0';
		wait for clock_period/2;
		clock <= '1';
		wait for clock_period/2;
   end process;
 

   -- Stimulus process
   stim_proc: process
   begin
      -- hold reset state for 10 ns.
		X <= (others => '0');
		Y <= (others => '0');
      wait for 10 ns;
		
      -- insert stimulus here
		
		--Error Check Min
		X <= X"00000001";										--Set input
		Y <= conv_std_logic_vector(1,32);				--Set input
		wait for clock_period;								--Wait for gate delay
		--If not correct then report Error
		Assert ( D = conv_std_logic_vector(0,32) and 
					B = '0') 									--Output check
			Report "Error at Min."							--Report to command line
			Severity ERROR;									--Type of severity to report
			
		--Error Check underflow 1
		X <= X"00000000";										--Set input
		Y <= conv_std_logic_vector(1,32);				--Set input
		wait for clock_period;								--Wait for gate delay
		--If not correct then report Error
		Assert ( D = X"FFFFFFFF" and 
					B = '1' ) 									--Output check
			Report "Error at Underflow 1."				--Report to command line
			Severity ERROR;									--Type of severity to report

		--Error Check underflow 2
		X <= X"00000000";										--Set input
		Y <= X"FFFFFFFF";										--Set input
		wait for clock_period;								--Wait for gate delay
		--If not correct then report Error
		Assert ( D = X"00000001" 
					and B = '1' ) 								--Output check
			Report "Error at Underflow 2."				--Report to command line
			Severity ERROR;									--Type of severity to report

		--Error Check for ranged subtractions
		for N in 1024 downto 512 loop
			for M in 512 downto 0 loop
				X <= conv_std_logic_vector(N,32);				--Set input to N with 32 bit range
				Y <= conv_std_logic_vector(M,32);				--Set input to M with 32 bit range
				wait for clock_period;								--Wait for gate delay
				--If not correct then report Error
				Assert ( D = conv_std_logic_vector(N-M,32) and 
							B = '0' ) 									--Output check with N+M value
					Report "Error at" &
							 " A=" & integer'image(N) &			--Print strings and N,M, N+M to
							 " B=" & integer'image(M) &			--  counsole upon error.
							 " S=" & integer'image(N-M) &
							 "."--Report to command line
					Severity ERROR;									--Type of severity to report
			end loop;
		end loop;
	--Systems runs for (10ns)*(3+(N+1)*(M+1))= ? ns
		
	Report "Done with testbench" Severity NOTE; 			--Report testbench complete.
   wait;
   end process;

END;
