--Names: John Doe, Jane Smith
--Login: jdoe, jsmith
--Email: jdoe@cs.ucr.edu, jsmith@cs.ucr.edu
--Lab Section: 0##
--Assignment: Lab #
--I acknowledge all content is original.

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity generic_subtractor is
    Generic ( WIDTH : INTEGER := 32);
    Port ( X : in  STD_LOGIC_VECTOR (WIDTH-1 downto 0);
           Y : in  STD_LOGIC_VECTOR (WIDTH-1 downto 0);
           D : out  STD_LOGIC_VECTOR (WIDTH-1 downto 0);
           B : out  STD_LOGIC);
end generic_subtractor;

architecture Structural of generic_subtractor is

component half_subtractor
    Port ( X : in  STD_LOGIC;
           Y : in  STD_LOGIC;
           D : out  STD_LOGIC;
           B : out  STD_LOGIC);
end component half_subtractor;

component full_subtractor
    Port ( BI : in  STD_LOGIC;
           X : in  STD_LOGIC;
           Y : in  STD_LOGIC;
           D : out  STD_LOGIC;
           B : out  STD_LOGIC);
end component full_subtractor;

signal B_sig : STD_LOGIC_VECTOR(WIDTH-1 downto 0);

	begin

		start : half_subtractor
			port map ( 
				X => X(0),
				Y => Y(0),
				D => D(0),
				B => B_sig(0)
				);

		gen_sub : for N in 1 to WIDTH-1 generate
			sub_unit : full_subtractor
				port map (
					  BI => B_sig(N-1),
					  X => X(N),
					  Y => Y(N),
					  D => D(N),
					  B => B_sig(N)
					);
		end generate gen_sub;

		B <= B_sig(WIDTH-1);

end Structural;

