// =====================================================================================
// 
//       Filename:  ReadInfoSE.hpp
// 
//    Description:  The implementation of class ReadInfoSE
// 
//        Version:  1.0
//        Created:  02/25/2010 10:47:58 PM
//       Revision:  none
//       Compiler:  g++
// 
//         Author:  Jianxing Feng (feeldead), feeldead@gmail.com
//        Company:  THU
// 
// =====================================================================================

#ifndef ReadInfoSE_H
#define ReadInfoSE_H

#include "ReadInfoBase.hpp"

/*
 * =====================================================================================
 *        Class:  ReadInfoSE
 *  Description:  This class defines information of single end read.
 * =====================================================================================
 */
class ReadInfoSE: public ReadInfoBase
{
	public:
		virtual void Write(ostream* p_out)
		{
			(*p_out) << "0" << endl;
			ReadInfoBase::Write(p_out);
		}
		// Given an isoform, the length of each segment and the index of
		// a segment, get all the informative patterns containing the 
		// specified segment and some segments before the specified 
		// segment and the virtual length of each pattern.
		virtual void InformativePatterns(const vector<bool>& isoform, const vector<int>& seg_lens, 
				vector<Pattern>& patterns, vector<double>& vir_lens, int curr_seg)
		{
			if (!isoform[curr_seg]) return;

			int range_low = mpReadLenDist->RangeLow();
			int range_high = mpReadLenDist->RangeHigh();

			int len_sum = 0;
			vector<int> temp_patt;
			for (int i = curr_seg; i >= 0; --i)
			{
				if (!isoform[i]) continue;
				len_sum += seg_lens[i];
				if (len_sum < range_low) continue;
				if (len_sum - seg_lens[curr_seg] - seg_lens[i] >= range_high - 2 * mCrossStrength) break;

				temp_patt.push_back(i);
				// Revert the order
				vector<int> segs;
				segs.resize(temp_patt.size());
				for (unsigned i = 0; i < temp_patt.size(); ++i)
					segs[i] = temp_patt[temp_patt.size() - i - 1];

				Pattern patt;
				patt.mMappedSegs.push_back(segs);

				double vir_len = PatternVirtualLength(isoform, seg_lens, patt);
				if (IsInformative(vir_len))
				{
					patterns.push_back(patt);
					vir_lens.push_back(vir_len);
				}
			}
		}

		virtual double PatternVirtualLength(const vector<bool>& isoform,
				const vector<int>& seg_lens, const Pattern& pattern)
		{
			if (pattern.mMappedSegs.size() != 1) return 0;
			const vector<int>& segs = pattern.mMappedSegs[0];
			if (segs.size() == 0) return 0;

			vector<bool> mask;
			mask.assign(isoform.size(), false);
			for (unsigned i = 0; i < segs.size(); ++i)
				mask[segs[i]] = true;

			int first_seg = segs[0];
			int last_seg = segs[segs.size()-1];
			// Check whether the pattern is legal
			for (int i = first_seg; i <= last_seg; ++i)
				if (isoform[i] != mask[i]) return 0;

			int gap_len = 0;
			for (unsigned i = 1; i < segs.size()-1; ++i)
				gap_len += seg_lens[segs[i]];

			if (mpReadLenDist->IsConstant())
			{
				int read_len = (int)mpReadLenDist->GetValue();

				if (first_seg != last_seg)
				{
					// ======-----------=======
					//    +++++++++++++++++
					// 0 <= start_pos <= len_of_first_seg - mCrossStrength;
					// len_of_first_seg + gap_len + mCrossStrength <= end_pos <= len_of_first_seg + gap_len + len_of_last_seg

					int low = read_len;
					if (low < seg_lens[first_seg] + gap_len + mCrossStrength)
						low = seg_lens[first_seg] + gap_len + mCrossStrength;

					int high = seg_lens[first_seg] - mCrossStrength + read_len;
					if (high > seg_lens[first_seg] + gap_len + seg_lens[last_seg])
						high = seg_lens[first_seg] + gap_len + seg_lens[last_seg];

					if (high >= low) return high - low + 1;
					else return 0;
				}
				else
				{
					if (seg_lens[first_seg] >= read_len) return seg_lens[first_seg] - read_len + 1;
					else return 0;
				}
			}
			else
			{
				double prob_sum = 0;
				for (int i = 0; i <= seg_lens[first_seg] - mCrossStrength; ++i)
				{
					int low = 0;
					int high = 0;
					if (first_seg != last_seg)
					{
						low = i + gap_len + mCrossStrength - 1;
						high = i + gap_len + seg_lens[last_seg];
					}
					else
					{
						low = i;
						high = seg_lens[first_seg];
					}
					prob_sum += mpReadLenDist->ProbInRange(low - i, high - i);
				}
				return prob_sum;
			}
		}
};

#endif
