/*
 * =====================================================================================
 *
 *       Filename:  InstanceGenerator.h
 *
 *    Description:  This is the header file for class InstanceGenerator
 *
 *        Version:  1.0
 *        Created:  04/09/2009 01:10:43 PM
 *       Revision:  none
 *       Compiler:  gcc
 *
 *         Author:  Jianxing Feng (feeldead), feeldead@gmail.com
 *        Company:  THU
 *
 * =====================================================================================
 */

#ifndef InstanceGenerator_H 
#define InstanceGenerator_H

#include <iostream>
#include "InstanceHandler.h"

using namespace std;

/*
 * =====================================================================================
 *        Class:  InstanceGenerator
 *  Description:  The base class of generating instances
 * =====================================================================================
 */
class InstanceGenerator
{
	public:
		/* ====================  LIFECYCLE     ======================================= */
		InstanceGenerator (ostream* p_output = NULL)
		{
			if (p_output) mpOutput = p_output;
			else mpOutput = &cout;
		};                             /* constructor */

		virtual ~InstanceGenerator (){};                             /* constructor */

		void
		SetHandler(InstanceHandler* p_handler){mpHandler = p_handler;};

		virtual
		void
		Initialize()
		{
			mpHandler->Initialize();
		};

		virtual
		bool
		Generate() = 0;


		virtual
		void
		CleanUp()
		{
			mpHandler->CleanUp();
		};

	protected:

		ostream* mpOutput;
		InstanceHandler* mpHandler;

	private:

}; /* -----  end of class InstanceGenerator  ----- */

#endif
