// =====================================================================================
// 
//       Filename:  ExpressionCalculator.h
// 
//    Description:  This is the header file for class ExpressionCalculator
// 
//        Version:  1.0
//        Created:  06/11/2009 04:53:39 PM
//       Revision:  none
//       Compiler:  g++
// 
//         Author:  Jianxing Feng (feeldead), feeldead@gmail.com
//        Company:  THU
// 
// =====================================================================================

#ifndef ExpressionCalculator_H 
#define ExpressionCalculator_H

#include <string>
#include <iostream>
#include "InstanceHandler.h"

using namespace std;

/*
 * =====================================================================================
 *        Class:  ExpressionCalculator
 *  Description:  This class calculate the expression levels of different isoforms 
 *                according to the mapped short reads
 * =====================================================================================
 */
class ExpressionCalculator : public InstanceHandler
{
	private:

		// If this variable is true, the read count on a segment will be handled simply
		int mHandleReadMethod;  

	public:
		/* ====================  LIFECYCLE     ======================================= */
		ExpressionCalculator (ExpEstimator* p_solver, ostream* p_output = NULL) : InstanceHandler(p_output)
		{
			mpSolver = p_solver;
		};                             /* constructor */

		virtual ~ExpressionCalculator (){};                             /* constructor */

		void SetHandleReadMethod (int b_method){mHandleReadMethod = b_method;}

		virtual
		void
		Initialize()
		{
		};

		virtual
		void
		OnInstance(Instance& an_instance)
		{
			vector<vector<bool> >   &isoforms    =       an_instance.mIsoforms;
			ShortReadGroup          &short_reads =       an_instance.mShortReadGroup;
			vector<double>          &iso_exp     =       an_instance.mIsoExp;
			vector<int>             &seg_lens    =       an_instance.mSegLen;

			vector<double> measure_read;
			vector<vector<double> > virtual_len_matrix;
			if (0 == mHandleReadMethod)
				short_reads.ContructMeasures(isoforms, seg_lens, measure_read, virtual_len_matrix);
			else if (1 == mHandleReadMethod)
				short_reads.ContructMeasuresSimple(isoforms, seg_lens, measure_read, virtual_len_matrix);
			else if (2 == mHandleReadMethod)
				short_reads.ContructMeasuresStart(isoforms, seg_lens, measure_read, virtual_len_matrix);
			else
				short_reads.ContructMeasures(isoforms, seg_lens, measure_read, virtual_len_matrix);
			double obj_val = mpSolver->Solve(virtual_len_matrix, measure_read);
			double pvalue = mpSolver->ResultPvalue();
			mpSolver->GetExpLevel(iso_exp);
			if (iso_exp.size() == 0) iso_exp.assign(isoforms.size(), 0);

			InstanceHandler::OnInstance(an_instance);
		}/* -----  end of method OnInstance  ----- */

		virtual
		void
		CleanUp(){}
}; /* -----  end of class ExpressionCalculator  ----- */

#endif
