/*
 * =====================================================================================
 *
 *       Filename:  ToolBase.cc
 *
 *    Description:  The implementation of class ToolBase
 *
 *        Version:  1.0
 *        Created:  05/16/2008 08:17:08 AM
 *       Revision:  11/20/2008 by feeldead`
 *       Compiler:  g++
 *
 *         Author:  Jianxing Feng (feeldead), feeldead@gmail.com
 *        Company:  THU
 *
 * =====================================================================================
 */
#include "ToolBase.h"
#include "Utility.hpp"
#include <iostream>
#include <cstdlib>

using namespace std;

/*
 *--------------------------------------------------------------------------------------
 *       Class:  ToolBase
 *      Method:  ToolBase
 * Description:  constructor
 *--------------------------------------------------------------------------------------
 */
ToolBase::ToolBase ()
{
}  /* -----  end of method ToolBase::ToolBase  (constructor)  ----- */


/*
 *--------------------------------------------------------------------------------------
 *       Class:  ToolBase
 *      Method:  ~ToolBase
 * Description:  destructor
 *--------------------------------------------------------------------------------------
 */
ToolBase::~ToolBase ()
{
}  /* -----  end of method ToolBase::~ToolBase  (destructor)  ----- */

/*
 *--------------------------------------------------------------------------------------
 *       Class:  ToolBase
 *      Method:  ArgMissing
 * Description:  The argument associated with "arg" is wrong. Default reaction is output
 *               this information to cerr.
 *       Param:  arg    :    A string ended with 0
 *      Return:
 *--------------------------------------------------------------------------------------
 */
	void	
ToolBase::ArgMissing (string arg)
{	
	cerr << arg << " is needed" << endl;
	return ;
}		/* -----  end of method ToolBase::ArgMissing  ----- */


/*
 *--------------------------------------------------------------------------------------
 *       Class:  ToolBase
 *      Method:  ParseDelimits
 * Description:  Parse delimits
 *       Param:  args : a string to be parsed
 *               delimits : parsed delimits
 *               tranc : escape character, \ is the default
 *        Note:  \t   for   tab
 *               \b   for   blank space
 *               \\   for   \
 *      Return:  None
 *--------------------------------------------------------------------------------------
 */
	void
ToolBase::ParseDelimits ( char* args, vector<char>& delimits, char escape = '\\')
{
	char c = 3;
	int idx = 0;
	bool tran = false;
	while (c)
	{
		c = args[idx++];
		if ( !c )
		{
			// End of string
			break;
		}
		if ( c == escape )
		{
			tran = true;
		}
		else
		{
			if (tran)
			{
				if (c == 't')
					delimits.push_back('\t');
				else if (c == 'b')
					delimits.push_back(' ');
				else if (c == escape )
					delimits.push_back(escape);
				else
					delimits.push_back(c);
				tran = false;
			}
			else
				delimits.push_back(c);
		}
	}
	return ;
}		/* -----  end of method ToolBase::ParseDelimits  ----- */


/*
 *--------------------------------------------------------------------------------------
 *       Class:  ToolBase
 *      Method:  ParseFields
 * Description:  Parse the fields given a string
 *       Param:  args : The string to be parsed
 *               fields : To the fields
 *        Note:  The fields are seperated by comma. i.e. The string is supposed to be 
 *               in the form of:  #,#,#,...#,
 *      Return:
 *--------------------------------------------------------------------------------------
 */
	void
ToolBase::ParseFields(char* args, vector<int>& fields)
{
	string fds = args;
	vector<char> arg_de;
	arg_de.push_back(',');
	vector<string> fds_str = Utility::Split(arg_de, fds);
	fields.clear();

	for (vector<string>::iterator iter = fds_str.begin();
			iter != fds_str.end(); iter++)
	{
		fields.push_back(atoi(iter->data()));
	}

	return ;
}		/* -----  end of method ToolBase::ParseFields  ----- */
