/*
 * =====================================================================================
 *
 *       Filename:  Instance.h
 *
 *    Description:  
 *
 *        Version:  1.0
 *        Created:  04/13/2009 03:20:18 PM
 *       Revision:  none
 *       Compiler:  gcc
 *
 *         Author:  Jianxing Feng (feeldead), feeldead@gmail.com
 *        Company:  THU
 *
 * =====================================================================================
 */

#ifndef Instance_H 
#define Instance_H

#include <vector>
#include <string>
#include "ShortReadGroup.hpp"

using namespace std;

/*
 * =====================================================================================
 *        Class:  Instance
 *  Description:  This class defines an instance for the LP problem
 * =====================================================================================
 */
class Instance
{
	public:
		int 					mInstanceCnt;

		// The length of each segment
		vector<int>  	        mSegLen;

		// A matrix mVSegLenOfIsoforms[i][j] is the virtual length
		// of isoform i on virtual segment j
		vector<vector<double> > mVSegLenOfIsoforms;

		// #Reads on each virtual segments
		vector<double>          mVSegReadCnt;  
		vector<vector<bool> > 	mIsoforms;

		vector<Exon> 			mExons;
		vector<Gene>            mGenes;     // The original data of gene information
		
		// Start and end pairs
		// Some data may provide all possible start and end combinations of possible
		// isoforms. This combination is different from normal paired end data because
		// it has not constraint on the length of the gap.
		// The length of mStartExon and mEndExon should be identical.
		// Isoforms start from an exon in mStartExons[i] must end with some exon in mEndExons[i]
		vector<vector<int> >    mStartExons;
		vector<vector<int> >    mEndExons;

		ShortReadGroup  	    mShortReadGroup;

		// These four variables can be read directly or generated by
		// LPsovler
		vector<double> 			mIsoExp;
		vector<double>          mFitValue;
		double 					mObjValue;
		double 					mPvalue;
	
		// The former mKnownCnt isoforms in mIsoNames are known isoforms
		int 					mKnownCnt;

}; /* -----  end of class Instance  ----- */

#endif
