/*
 * =====================================================================================
 *
 *       Filename:  GraphWriter.h
 *
 *    Description:  
 *
 *        Version:  1.0
 *        Created:  04/22/2008 09:39:06 PM
 *       Revision:  none
 *       Compiler:  g++
 *
 *         Author:  Jianxing Feng (feeldead), feeldead@gmail.com
 *        Company:  THU
 *
 * =====================================================================================
 */

#ifndef GraphWriter_h
#define GraphWriter_h

class Graph;
/*
 * =====================================================================================
 *        Class:  GraphWriter
 *  Description:  The base class for graph writers. A graph writer could be outputing the
 *                information or content of the graph to the terminal or displaying the
 *                graph on the screen.
 * =====================================================================================
 */
class GraphWriter
{
	public:
		enum WriteFormat {WRITE_GRAPH_SUMMARY, WRITE_GRAPH_FULL, WRITE_GRAPH_COMP};

		/* ====================  LIFECYCLE     ======================================= */
		GraphWriter ();                             /* constructor */

		/* ====================  OPERATORS     ======================================= */
		void SetGraph (Graph* pGraph);
		void SetFormat (WriteFormat format);

		virtual void Write();

		virtual void WriteSummary();
		virtual void WriteFull();
		virtual void WriteComponent();

		/* ====================  OPERATIONS    ======================================= */

		/* ====================  ACCESS        ======================================= */

		/* ====================  INQUIRY       ======================================= */

		/* ====================  DATA MEMBERS  ======================================= */
	protected:
		Graph* 	mpGraph;
		WriteFormat mWriteFormat;

	private:

}; /* -----  end of class  GraphWriter  ----- */

#endif
