/*
 * =====================================================================================
 *
 *       Filename:  GraphWriter.cc
 *
 *    Description:  The implementation of class GraphWriter
 *
 *        Version:  1.0
 *        Created:  04/22/2008 09:42:33 PM
 *       Revision:  none
 *       Compiler:  g++
 *
 *         Author:  Jianxing Feng (feeldead), feeldead@gmail.com
 *        Company:  THU
 *
 * =====================================================================================
 */

#include "GraphWriter.h"
#include "Graph.h"
#include "GraphAlgorithm_Basic.hpp"
#include <iostream>
#include <list>
#include <set>

using namespace std;

/*
 *--------------------------------------------------------------------------------------
 *       Class:  GraphWriter
 *      Method:  GraphWriter
 * Description:  constructor
 *--------------------------------------------------------------------------------------
 */
GraphWriter::GraphWriter ()
{
	mWriteFormat = WRITE_GRAPH_SUMMARY;
	mpGraph = 0;
}  /* -----  end of method GraphWriter::GraphWriter  (constructor)  ----- */

/*
 *--------------------------------------------------------------------------------------
 *       Class:  GraphWriter
 *      Method:  SetGraph (Graph* pGraph)
 * Description:  
 *       Param:  
 *      Return:
 *--------------------------------------------------------------------------------------
 */
/*virtual*/ void
GraphWriter::SetGraph (Graph* pGraph)
{
	mpGraph = pGraph;
	return ;
}		/* -----  end of method GraphWriter::SetGraph (Graph* pGraph)  ----- */


/*
 *--------------------------------------------------------------------------------------
 *       Class:  GraphWriter
 *      Method:  Write 
 * Description:  The default behavior is to write the graph to the console
 *       Param:  
 *      Return:
 *--------------------------------------------------------------------------------------
 */
/*virtual*/ void
GraphWriter::Write ()
{
	if (!mpGraph)
	{
		cerr << "Error. No graph assigned" << endl;
		return;
	}

	switch (mWriteFormat)
	{
		case WRITE_GRAPH_SUMMARY:
			WriteSummary();
			break;
		case WRITE_GRAPH_FULL:
			WriteFull();
			break;
		case WRITE_GRAPH_COMP:
			WriteComponent();
			break;
		default :
			WriteSummary();
	}
	
	return ;
}		/* -----  end of method GraphWriter::Write ----- */


/*
 *--------------------------------------------------------------------------------------
 *       Class:  GraphWriter
 *      Method:  WriteSummary
 * Description:  The default behavior is to write the graph to the console
 *       Param:  
 *      Return:
 *--------------------------------------------------------------------------------------
 */
/*virtual*/ void
GraphWriter::WriteSummary ()
{
	cout << "All node count : " << mpGraph->NodeCnt(false)<< endl;
	cout << "All edge count : " << mpGraph->EdgeCnt(false) << endl;
	cout << "Unmasked node count : " << mpGraph->NodeCnt()<< endl;
	cout << "Unmasked edge count : " << mpGraph->EdgeCnt() << endl;
	return ;
}		/* -----  end of method GraphWriter::WriteSummary ----- */

/*
 *--------------------------------------------------------------------------------------
 *       Class:  GraphWriter
 *      Method:  WriteFull
 * Description:  The default behavior is to write the graph to the console
 *       Param:  
 *      Return:
 *--------------------------------------------------------------------------------------
 */
/*virtual*/ void
GraphWriter::WriteFull ()
{
	WriteSummary();

	cout << "nodes, neighbors" << endl;
	const int* nodes = mpGraph->Nodes();
	for (int i = 0; i < mpGraph->NodeCnt(); i++)
	{
		int node = nodes[i];
		cout << node << "    In : ";
		const int* edges = mpGraph->InEdges(node);
		for (int j = 0; j < mpGraph->InDegree(node); j++)
			cout << mpGraph->FromNode(edges[j]) << ",";
		cout << endl << "     Out: ";
		edges = mpGraph->OutEdges(node);
		for (int j = 0; j < mpGraph->OutDegree(node); j++)
			cout << mpGraph->ToNode(edges[j]) << ",";
		cout << endl;
	}
	cout << "adj edges" << endl;
	nodes = mpGraph->Nodes();
	for (int i = 0; i < mpGraph->NodeCnt(); i++)
	{
		int node = nodes[i];
		cout << node << "    In : ";
		const int* edges = mpGraph->InEdges(node);
		for (int j = 0; j < mpGraph->InDegree(node); j++)
			cout << edges[j] << ",";
		cout << endl << "     Out: ";
		edges = mpGraph->OutEdges(node);
		for (int j = 0; j < mpGraph->OutDegree(node); j++)
			cout << edges[j] << ",";
		cout << endl;
	}
	return ;
}		/* -----  end of method GraphWriter::WriteFull ----- */

/*
 *--------------------------------------------------------------------------------------
 *       Class:  GraphWriter
 *      Method:  WriteComponent
 * Description:  The default behavior is to write the graph to the console
 *       Param:  
 *      Return:
 *--------------------------------------------------------------------------------------
 */
/*virtual*/ void
GraphWriter::WriteComponent ()
{
	list<set<int> > comps;
	GraphAlgorithm_Basic::Components(mpGraph, comps);
	cout << "There are " << comps.size() << " components." << endl;

	int cnt = 0;
	for_each_ele_in_group(iter, list<set<int> >, comps)
	{
		cout << "Comp" << cnt++ << "  " << iter->size() << endl;
		for_each_ele_in_group(iter2, set<int>, *iter)
			cout << *iter2 << "\t" << endl;
	}

	return ;
}		/* -----  end of method GraphWriter::WriteComponent ----- */
