/*
 * =====================================================================================
 *
 *       Filename:  GraphExReader.cc
 *
 *    Description:  The implementation of class GraphExReader
 *
 *        Version:  1.0
 *        Created:  04/22/2008 10:12:00 PM
 *       Revision:  none
 *       Compiler:  g++
 *
 *         Author:  Jianxing Feng (feeldead), feeldead@gmail.com
 *        Company:  THU
 *
 * =====================================================================================
 */

#include <iostream>
#include <fstream>
#include "GraphExReader.h"
#include "GraphEx.hpp"
#include <string>


/*
 *--------------------------------------------------------------------------------------
 *       Class:  GraphExReader
 *      Method:  GraphExReader
 * Description:  constructor
 *--------------------------------------------------------------------------------------
 */
GraphExReader::GraphExReader ()
{
	mFieldEdgeFrom = 0;
	mFieldEdgeTo = 1;
	mFieldEdgeExID = -1;
	mDelimits.push_back('\t');
}  /* -----  end of method GraphExReader::GraphExReader  (constructor)  ----- */

/*
 *--------------------------------------------------------------------------------------
 *       Class:  GraphExReader
 *      Method:  SetGraph (Graph* pGraph)
 * Description:  
 *       Param:  A pointer to an instance of class GraphEx not Graph
 *      Return:
 *--------------------------------------------------------------------------------------
 */
/*virtual*/ bool 
GraphExReader::SetGraph (Graph* pGraph)
{
	GraphEx<string>* pGraphEx = dynamic_cast<GraphEx<string>*>(pGraph);
	if (!pGraphEx)
	{
		cerr << "Set graph failed" << endl;
		cerr << "An pointer to an object of class GraphEx<string> is expected" << endl;
		return false;
	}
	mpGraph = pGraph;
	return true;
}		/* -----  end of method GraphExReader::SetGraph (Graph* pGraph)  ----- */


/*
 *--------------------------------------------------------------------------------------
 *       Class:  GraphExReader
 *      Method:  SetFields
 * Description:  
 *       Param:  
 *      Return:
 *--------------------------------------------------------------------------------------
 */
	void
GraphExReader::SetFields (int edge_from, int edge_to, int edge_ex_id)
{
	mFieldEdgeFrom = edge_from;
	mFieldEdgeTo = edge_to;
	mFieldEdgeExID = edge_ex_id;
	return ;
}		/* -----  end of method GraphExReader::SetFields  ----- */


/*
 *--------------------------------------------------------------------------------------
 *       Class:  GraphExReader
 *      Method:  SetDelimits
 * Description:  
 *       Param:  
 *      Return:
 *--------------------------------------------------------------------------------------
 */
	void
GraphExReader::SetDelimits ( vector<char> delimits )
{
	mDelimits.assign(delimits.begin(), delimits.end());
	return ;
}		/* -----  end of method GraphExReader::SetDelimits  ----- */
/*
 *--------------------------------------------------------------------------------------
 *       Class:  GraphExReader
 *      Method:  SetFile (string file)
 * Description:  Set the file from which the reader reads data
 *       Param:  file    :    The path of the file
 *      Return:
 *--------------------------------------------------------------------------------------
 */
void
GraphExReader::SetFile (string file)
{
	mFile = file;
	return ;
}		/* -----  end of method GraphExReader::SetFile (string file)  ----- */

/*
 *--------------------------------------------------------------------------------------
 *       Class:  GraphExReader
 *      Method:  Read
 * Description:  
 *       Param:  
 *      Return:
 *--------------------------------------------------------------------------------------
 */
/*virtual*/ bool 
GraphExReader::Read ()
{
	if (!mpGraph)
	{
		cerr << "No graphex is specified" << endl;
	}


	cout << "Reading nodes and edges from file : " << mFile << endl;
	fstream graphFile;
	graphFile.open(mFile.data(), ios::in);
	if (!graphFile.is_open())
	{
		cerr << "ERROR : The file can't be opened" << endl;
		return false;
	}

	GraphEx<string>* pGraphEx = (GraphEx<string>*)mpGraph;

	string line;
	while (getline(graphFile, line))
	{
		if (line[0] == '#') continue;
		vector<string> fields = Utility::Split(mDelimits, line);
		int fields_cnt = fields.size();
		if (0 <= mFieldEdgeFrom && mFieldEdgeFrom < fields_cnt && 
			0 <= mFieldEdgeTo && mFieldEdgeTo < fields_cnt)
		{
			if (0 <= mFieldEdgeExID && mFieldEdgeExID < fields_cnt)
				pGraphEx->AddEdgeEx(fields[mFieldEdgeFrom], fields[mFieldEdgeTo], fields[mFieldEdgeExID]);
			else
				pGraphEx->AddEdgeEx(fields[mFieldEdgeFrom], fields[mFieldEdgeTo], "");
		}
	}

	cout << "Reading finished successfully" << endl;

	return true;
}		/* -----  end of method GraphExReader::Read  ----- */

