/*
 * =====================================================================================
 *
 *       Filename:  main.cc
 *
 *    Description:  The main entrance of various small tools
 *
 *        Version:  1.0
 *        Created:  05/13/2008 05:10:53 PM
 *       Revision:  none
 *       Compiler:  g++
 *
 *         Author:  Jianxing Feng (feeldead), feeldead@gmail.com
 *        Company:  THU
 *
 * =====================================================================================
 */

#include <iostream>
#include "GenResult.h"
#include "DataProcessor.h"
#include "MishMash.h"
#include "ReleaseInterface.h"

//#include "JunctionDetector.h"

using namespace std;

void Help()
{
	cout << 											endl;
	cout << "        Usage : isoinfer <function name>" << endl;
	cout << 											endl;
	cout << "             function name : " << endl;
	cout << 											endl;
	cout << "                  gen_result : Generate all the results of the paper" << endl;
	cout << 											endl;
	cout << "                  dp    :   Data processing "          << endl;
	cout << 											endl;
	cout << "                  jd    :   Junction Detection "          << endl;
	cout << 											endl;
	cout << "                  mm    :   Other work"          << endl;
	cout << 											endl;
}

int 
main(int argc, char* argv[])
{
	if (argc > 1 && (strcmp(argv[1], "gen_result") == 0))
	{
		GenResult gen;
		gen.Main(argc, argv, 2);
	}
	else if (argc > 1 && (strcmp(argv[1], "dp") == 0))
	{
		DataProcessor dp;
		dp.Main(argc, argv, 2);
	}
	else if (argc > 1 && (strcmp(argv[1], "mm") == 0))
	{
		MishMash mm;
		mm.Main(argc, argv, 2);
	}
	else if (argc > 1 && (strcmp(argv[1], "jd") == 0))
	{
		//JunctionDetector jd;
		//jd.Main(argc, argv, 2);
	}
	else
	{
		ReleaseInterface ri;
		ri.Main(argc, argv, 1);
	}
	return 0;
}
