/*
 * =====================================================================================
 *
 *       Filename:  InstanceHandler.h
 *
 *    Description:  The base class of handing an instance
 *
 *        Version:  1.0
 *        Created:  04/09/2009 12:11:55 PM
 *       Revision:  none
 *       Compiler:  gcc
 *
 *         Author:  Jianxing Feng (feeldead), feeldead@gmail.com
 *        Company:  THU
 *
 * =====================================================================================
 */

#ifndef InstanceHandler_H 
#define InstanceHandler_H

#include <iostream>
#include <vector>
#include <string>
#include "LPsolver.h"
#include "Exon.h"
#include "Instance.h"

using namespace std;

/*
 * =====================================================================================
 *        Class:  InstanceHandler
 *  Description:  The base class of handing an instance
 * =====================================================================================
 */
class InstanceHandler
{
	public:
		/* ====================  LIFECYCLE     ======================================= */
		InstanceHandler (ostream* p_output = NULL)
		{
			if (p_output) mpOutput = p_output;
			else mpOutput = &cout;
		};                             /* constructor */


		void
		SetSolver(LPsolver* p_solver){mpSolver = p_solver;};

		void
		AddHandler(InstanceHandler* p_handler)
		{
			mHandlers.push_back(p_handler);
		}

		void
		RemoveHandler(InstanceHandler* p_handler)
		{
			for_each_ele_in_group(iter, vector<InstanceHandler*>, mHandlers)
			{
				if (*iter == p_handler)
				{
					mHandlers.erase(iter);
					break;
				}
			}
		}

		virtual ~InstanceHandler (){};                             /* constructor */

		virtual
		void
		Initialize()
		{
			for (unsigned i = 0; i < mHandlers.size(); i++)
				mHandlers[i]->Initialize();
		};

		virtual
		void
		OnInstance (Instance& an_instance)
		{
			mpInstance = &an_instance;
			for (unsigned i = 0; i < mHandlers.size(); i++)
				mHandlers[i]->OnInstance(an_instance);
		}

		virtual
		void
		CleanUp()
		{
			for (unsigned i = 0; i < mHandlers.size(); i++)
				mHandlers[i]->CleanUp();
		};

	protected:
		Instance* mpInstance;
		ostream* mpOutput;
		LPsolver* mpSolver;
		vector<InstanceHandler*> mHandlers;

	private:

}; /* -----  end of class InstanceHandler  ----- */

#endif
