/*
 * =====================================================================================
 *
 *       Filename:  Instance.h
 *
 *    Description:  
 *
 *        Version:  1.0
 *        Created:  04/13/2009 03:20:18 PM
 *       Revision:  none
 *       Compiler:  gcc
 *
 *         Author:  Jianxing Feng (feeldead), feeldead@gmail.com
 *        Company:  THU
 *
 * =====================================================================================
 */

#ifndef Instance_H 
#define Instance_H

#include <vector>
#include <string>

using namespace std;

/*
 * =====================================================================================
 *        Class:  PEInfo
 *  Description:  This class defines paired-end information with given gap range
 * =====================================================================================
 */
class PEInfo
{
public:
	// A paired-end is a partial combination of the exons.
	vector<vector<bool> >   mPartComb;
	// mPartCombDup is the number of duplicates for each element in mPartComb
	vector<int>             mPartCombDup;

	// The range of the gap between the two ends of a paired read.
	int                     mSpanLow;
	int                     mSpanHigh;

	// The mean and standard deviation of the gap of a paired end, if it obeys
	// a normal distribution
	double                  mSpanMean;
	double                  mSpanStd;

	int                     mReadLen;
	int 					mReadCnt;
};

/*
 * =====================================================================================
 *        Class:  Instance
 *  Description:  This class defines an instance for the LP problem
 * =====================================================================================
 */
class Instance
{
	public:
		int 					mInstanceCnt;
		vector<int> 			mSetSizes;
		vector<vector<bool> > 	mIsoforms;

		 /* :WARNING:04/24/2009 01:27:05 PM:feeldead: Change the type of number 
		  * of reads on each exon or junction from 'int' to 'double'. This is
		  * very important to handle small exons. In that case, we may assign
		  * a fraction of a read to a junction*/
		vector<double> 			mSampleCnt;
		vector<vector<double> >	mSpliceReadCnt;

		// The splice count abtained from PE reads.
		vector<vector<double> >	mSpliceReadCntPE;
		vector<Exon> 			mExons;
		vector<Gene>            mGenes;     // The original data of gene information
		string 					mComments;

		
		// Start and end pairs
		// Some data may provide all possible start and end combinations of possible
		// isoforms. This combination is different from normal paired end data because
		// it has not constraint on the length of the gap.
		// The length of mStartExon and mEndExon should be identical.
		// Isoforms start from an exon in mStartExons[i] must end with some exon in mEndExons[i]
		vector<vector<int> >    mStartExons;
		vector<vector<int> >    mEndExons;

		// It is possible that several groups of PE information is provided with
		// each group corresponding to a gap range.
		vector<PEInfo>          mPEInfo;

		// These four variables can be read directly or generated by
		// LPsovler
		vector<double> 			mIsoExp;
		vector<double>          mFitValue;
		double 					mObjValue;
		double 					mPvalue;

		// For a read across junction, each of the involved exon must
		// contribute at least mCrossStrength bases.
		int 					mCrossStrength;
		int 					mReadLen;
		int 					mReadCnt;
		double 					mNoiseLevel;
		
		// The former mKnownCnt isoforms in mIsoNames are known isoforms
		int 					mKnownCnt;

		// Maximum number of possible new isoforms;
		//int 					mHidedCnt;

		// This parameter is critical
		//double 					mConfidenceLevel;

		/*
		// This two variables are saved for efficiency
		int 					mTotalReads;
		int 					mGeneLen;
		*/
}; /* -----  end of class Instance  ----- */

#endif
