/*
 * =====================================================================================
 *
 *       Filename:  Utility.hpp
 *
 *    Description:  The definition of namespace Utility
 *
 *        Version:  1.0
 *        Created:  03/21/2008 12:17:36 PM
 *       Revision:  none
 *       Compiler:  g++
 *
 *         Author:  Jianxing Feng (feeldead), feeldead@gmail.com
 *        Company:  THU
 *
 * =====================================================================================
 */

#include <iostream>
#include <string>
#include <vector>
#include <fstream>
#include <vector>
#include <set>
#include <map>

using namespace std;

#ifndef Utility_h 
#define Utility_h 

#define for_each_ele_in_group_temp(_Iter, _GroupType, _Group) \
	for (typename _GroupType::iterator _Iter = (_Group).begin(); _Iter != (_Group).end(); _Iter++)

#define for_each_ele_in_group_const_temp(_Iter, _GroupType, _Group) \
	for (typename _GroupType::const_iterator _Iter = (_Group).begin(); _Iter != (_Group).end(); _Iter++)

#define for_each_ele_in_group(_Iter, _GroupType, _Group) \
	for (_GroupType::iterator _Iter = (_Group).begin(); _Iter != (_Group).end(); _Iter++)

#define for_each_ele_in_group_const(_Iter, _GroupType, _Group) \
	for (_GroupType::const_iterator _Iter = (_Group).begin(); _Iter != (_Group).end(); _Iter++)

typedef unsigned long long uint64;
typedef signed long long int64;

typedef map<int64, int> map_64_32;

typedef map<string, int>				map_str2int;
typedef map<string, int>::iterator		map_str2int_iter;
typedef map<string, int>::value_type	map_str2int_pair;

typedef multimap<int, string, greater<int> >				multimap_int2str;
typedef multimap<int, string, greater<int> >::value_type	multimap_int2str_pair;
typedef multimap<int, string, greater<int> >::iterator		multimap_int2str_iter;

template <typename T1, typename T2>
T1 max(T1 ele1, T2 ele2)
{
	return (ele1 > ele2) ? ele1 : ele2;
}

class Utility
{
public:
	static string Transform2UniqueString(vector<int>& set);
	static string Transform2UniqueString(set<int>& set);
	inline static char Digit2Hex(char digit);
	inline static double minusError(double& result, double& op1, double& op2);
	inline static double plusError(double& result, double& op1, double& op2);
	static double precisionControl(double fnum, int precision);
	static vector<string> Split(const vector<char>& delimits, const string& data, char escape = '\\');
	static vector<string> Split(char delimit, const string& data, char escape = '\\');
	static int64 combine64(int int1, int int2);
	inline static int get_combined64_first(int64 combined){return ((combined >> 32) & 0xFFFFFFFF);};
	inline static int get_combined64_second(int64 combined){return (combined & 0xFFFFFFFF);};
	static int SearchLeader(vector<int>& leaders, int element);
	static void Union(vector<int>& sizes, vector<int>& leaders, int ele1, int ele2);
};

template <typename Type, typename TComp = greater<Type> >
class UtilityTemp
{
public:
	inline static void 
	Switch (Type& A, Type& B)
	{
		Type temp = A;
		A = B;
		B = temp;
		return ;
	}		/* -----  end of method Utility::Switch  ----- */

	static void Shrink(vector<Type>& aSet)
	{
		int i = 0;
		for (typename vector<Type>::iterator Iter = aSet.begin(); Iter != aSet.end(); Iter++)
		{
			if (*Iter)
				aSet[i++] = *Iter;
		}
		aSet.resize(i);
	}

	static void Shrink(vector<Type>& aSet, vector<int>& shrinkedIndex)
	{
		shrinkedIndex.resize(aSet.size());
		int i, j;
		for (i = j = 0; j < aSet.size(); j++)
		{
			if (aSet[j])
			{
				shrinkedIndex[i] = j;
				aSet[i++] = aSet[j];
			}
		}
		aSet.resize(i);
		shrinkedIndex.resize(i);
	}

	static void ShrinkByIndex(vector<Type>& aSet, vector<int>& shrinkedIndex)
	{
		int i;
		for (i = 0; i < shrinkedIndex.size(); i++)
		{
			aSet[i] = aSet[shrinkedIndex[i]];
		}
		aSet.resize(i);
	}


	static void FreeVectorPointer(vector<Type>& aSet)
	{
		for_each_ele_in_group_temp(Iter, vector<Type>, aSet)
		{
			delete *Iter;
		}
	}

	static void Sort(vector<Type>& keys, vector<int>& sortedIndex)
	{
		int i;

		sortedIndex.resize(keys.size());
		for (i = 0; i < sortedIndex.size(); i++)
			sortedIndex[i] = i;

		typedef multimap<Type, int, TComp> SORTMAP;
		typedef typename multimap<Type, int, TComp>::value_type PAIR;

		SORTMAP sortMap;

		for (i = 0; i < keys.size(); i++)
			sortMap.insert(PAIR(keys[i], i));

		i = 0;
		for_each_ele_in_group_temp(Iter, SORTMAP, sortMap)
		{
			keys[i] = Iter->first;
			sortedIndex[i++] = Iter->second;
		}
	}

	static void StableSort(vector<Type>& keys, vector<int>& sortedIndex)
	{
		sortedIndex.resize(keys.size());
		for (int i = 0; i < sortedIndex.size(); i++)
			sortedIndex[i] = i;

		TComp compare;
		for (int i = 0; i < keys.size() - 1; i++)
		{
			int opt = i;
			for (int j = i + 1; j < keys.size(); j++)
			{
				if (compare(keys[j], keys[opt])) opt = j;
			}
			Type tt = keys[opt];
			keys[opt] = keys[i];
			keys[i] = tt;

			int idx = sortedIndex[opt];
			sortedIndex[opt] = sortedIndex[i];
			sortedIndex[i] = idx;
		}
	}

	static void SortByIndex(vector<Type>& values, vector<int>& sortedIndex)
	{
		vector<bool> index_check;
		index_check.resize(sortedIndex.size());
		index_check.assign(sortedIndex.size(), false);
		for (int i = 0; i < sortedIndex.size(); i++)
			index_check[sortedIndex[i]] = true;
		for (int i = 0; i < sortedIndex.size(); i++)
			if (!index_check[sortedIndex[i]])
				cerr << __func__ << " ERROR invalid sortedIndex " << endl;

		if (sortedIndex.size() != values.size())
		{
			cerr << __func__ << " ERROR " << " : Two arrays have different length" << endl;
			return;
		}
		vector<Type> dups = values;
		for (int i = 0; i < sortedIndex.size(); i++)
			values[i] = dups[sortedIndex[i]];
	}

	static int Intersection(set<Type >& set1, set<Type >& set2)
	{
		set<Type>* set_1 = &set1;
		set<Type>* set_2 = &set2;
		if (set1.size() > set2.size())
		{
			set_1 = &set2;
			set_2 = &set1;
		}
		int cnt = 0;
		for_each_ele_in_group_temp(iter, set<Type>, *set_1)
		{
			if (set_2->find(*iter) != set_2->end())
				cnt++;
		}
		return cnt;
	}

	static int Intersection(set<Type>& set1, set<Type>& set2, set<Type>& result)
	{
		set<Type>* set_1 = &set1;
		set<Type>* set_2 = &set2;
		if (set1.size() > set2.size())
		{
			set_1 = &set2;
			set_2 = &set1;
		}
		int cnt = 0;
		for_each_ele_in_group_temp(iter, set<Type>, *set_1)
		{
			if (set_2->find(*iter) != set_2->end())
			{
				cnt++;
				result.insert(*iter);
			}
		}
		return cnt;
	}
};

#endif
