/*
 * =====================================================================================
 *
 *       Filename:  ExpEstimator.h
 *
 *    Description:  This file is modified based on the file with the same name in HuiJiang's
 *                  rseq-0.0.4 package. The modification is for handling different type of 
 *                  short reads. The main modification is L
 *
 *        Version:  1.0
 *        Created:  Sat Mar 20 13:14:29 CST 2010
 *       Revision:  none
 *       Compiler:  gcc
 *
 *         Author:  Jianxing Feng (feeldead), feeldead@gmail.com
 *        Company:  THU
 *
 * =====================================================================================
 */

#ifndef ISOFORM_OPT_H
///Define this macro to prevent from including this header file more than once.
#define ISOFORM_OPT_H

const double epsilon = 1e-10;
const int max_iteration = 10000;

/*vector<vector<double> > inv_matrix(const vector<vector<double> > &matrix) {
	int m = (int)matrix.size(), n = (int)matrix[0].size();
	MATRIX input, *output;
	input.init((short)m, (short)n);
	for (int i = 0; i < m; i++)
		for (int j = 0; j < n; j++)
			input.put(i, j, matrix[i][j]);
	output = input.inverse();
	vector<vector<double> > result;
	result.resize(m);
	for (int i = 0; i < m; i++) {
		result[i].resize(m);
		for (int j = 0; j < m; j++)
			result[i][j] = output->get(i,j);
	}
	delete output;
	return result;
}*/

class isoform_opt{
public:
	bool verbose;
	int M; //number of subexon_sets
	int K; //number of isoforms
	// Note, in the modified version, the calculated expression level would be absolute value instead of RPKM
	// double NN; //total number of mappable reads
	vector<double> N; //subexon_set read counts
	vector<vector<double> > L; //subexon_set lengths; L[i][j] is the length of j'th subexon in isoform i
	vector<vector<bool> > A; //subexon_set_indicator matrix; A[i][j] is true if isoform i contain subexon_set j;

	isoform_opt() {verbose = false;}

	double log_likelihood(const vector<double> &X) {
		double result = 0;
		double temp1 = 0;	
		for (int i = 0; i < M; i++) {
			double temp2 = 0;
			for (int j = 0; j < K; j++) {
				if (A[j][i]) temp2 += X[j] * L[j][i];
			}
			temp1 += temp2;
		}
		result -= temp1 * 1;
		temp1 = 0;
		for (int i = 0; i < M; i++) {
			double temp2 = 0;
			for (int j = 0; j < K; j++) {
				if (A[j][i]) temp2 += X[j];
			}
			temp1 += log(temp2 + epsilon) * N[i];
		}
		result += temp1;
		return result;
	}

	double grad_log_likelihood(const vector<double> &X, int k) {
		double result = 0;
		double temp1 = 0;	
		for (int i = 0; i < M; i++) {
			if (A[k][i]) temp1 += L[k][i];
		}
		result -= temp1 * 1;
		temp1 = 0;
		for (int i = 0; i < M; i++) {
			if (!A[k][i]) continue;
			double temp2 = 0;
			for (int j = 0; j < K; j++) {
				if (A[j][i]) temp2 += X[j];
			}
			temp1 += N[i] / (temp2 + epsilon);
		}
		result += temp1;
		return result;
	}

	vector<double> grad_log_likelihood(const vector<double> &X) {
		vector<double> grad;
		grad.resize(K);
		for (int i = 0; i < K; i++) {
			grad[i] = grad_log_likelihood(X, i);
		}
		return grad;
	}

	vector<vector<double> > hessian_log_likelihood(const vector<double> &X) {
		vector<vector<double> > hessian;
		hessian.resize(K);
		for (int i = 0; i < K; i++) hessian[i].resize(K);
		vector<double> temp1;
		temp1.resize(M);
		for (int i = 0; i < M; i++) {
			double temp2 = 0;
			for (int j = 0; j < K; j++) {
				if (A[j][i]) temp2 += X[j];
			}
			temp1[i] = N[i] / (temp2 + epsilon) / (temp2 + epsilon);
		}
		for (int k = 0; k < K; k++) {
			for (int l = 0; l < K; l++) {
				hessian[k][l] = 0;
				for (int i = 0; i < M; i++) {
					if (A[k][i] && A[l][i]) hessian[k][l] -= temp1[i];
				}
				if (k == l) hessian[k][l] -= 1e-6;
			}
		}
		return hessian;
	}

	vector<vector<double> > obs_fisher(const vector<double> &X) {
		vector<vector<double> > temp = hessian_log_likelihood(X);
		for (int i = 0; i < K; i++)
			for (int j = 0; j < K; j++)
				temp[i][j] = -temp[i][j];
		return temp;
	}

/*	vector<vector<double> > inv_obs_fisher(const vector<double> &X) {
		return inv_matrix(obs_fisher(X));
	}*/
	
	vector<vector<double> > fisher(const vector<double> &X) {
		vector<vector<double> > fisher;
		fisher.resize(K);
		for (int i = 0; i < K; i++) fisher[i].resize(K);
		vector<double> temp1;
		temp1.resize(M);
		for (int i = 0; i < M; i++) {
			double temp2 = 0;
			for (int j = 0; j < K; j++) {
				if (A[j][i]) temp2 += L[j][i] * X[j];
			}
			temp1[i] = 1  / (temp2 + epsilon);
		}
		for (int k = 0; k < K; k++) {
			for (int l = 0; l < K; l++) {
				fisher[k][l] = 0;
				for (int i = 0; i < M; i++) {
					if (A[k][i] && A[l][i]) fisher[k][l] += temp1[i] * L[k][M] * L[l][M];
				}
				if (k == l) fisher[k][l] += 1e-6;
			}
		}
		return fisher;
	}

/*	vector<vector<double> > inv_fisher(const vector<double> &X) {
		return inv_matrix(fisher(X));
	}*/

	double fmax_coord(vector<double> &X, int k) {
		double f_value = log_likelihood(X);
		double grad = grad_log_likelihood(X, k);
		if (grad > 0) grad = 1; else if (grad < 0) grad = -1; else return f_value;
		double x_old = X[k];
		double step = 1e6;
		int iteration = 0;
		while (true) {
			X[k] = x_old + step * grad;
			if (X[k] < 0) X[k] = 0;
			double new_f_value = log_likelihood(X);
			if (new_f_value > f_value) return new_f_value;
			if (step > epsilon) step /= 2; else break;
			if (iteration < max_iteration) iteration++; else break;
		}
		if (iteration >= max_iteration) cerr << "warning: iteration >= max_iteration\n";
		X[k] = x_old;
		return f_value;
	}

	double fmax_coord(vector<double> &X) {
		double f_value = log_likelihood(X);
		int iteration = 0;
		while (true) {
			if (verbose) {
				cerr << "iteration: " << iteration << " value: " << f_value << " X: ";
				for (int i = 0; i < K; i++) cerr << X[i] << ",";
				cerr << endl;
			}
			for (int i = 0; i < K; i++) {
				fmax_coord(X, i);
			}
			double new_f_value = log_likelihood(X);
			if (fabs(f_value - new_f_value) < epsilon) {
				if (verbose) cerr << "number of iteration: " << iteration << endl;
				return new_f_value;
			}
			f_value = new_f_value;
			if (iteration < max_iteration) iteration++; else break;
		}
		if (iteration >= max_iteration) cerr << "warning: iteration >= max_iteration\n";
		return f_value;
	}
};

#endif // ISOFORM_OPT_H
