/*
 * =====================================================================================
 *
 *       Filename:  GraphExReader.h
 *
 *    Description:  
 *
 *        Version:  1.0
 *        Created:  04/22/2008 10:08:40 PM
 *       Revision:  none
 *       Compiler:  g++
 *
 *         Author:  Jianxing Feng (feeldead), feeldead@gmail.com
 *        Company:  THU
 *
 * =====================================================================================
 */

#ifndef GraphExReader_h
#define GraphExReader_h

#include "GraphReader.h"
#include <string>
#include <vector>
#include "Utility.hpp"

using namespace std;

/*
 * =====================================================================================
 *        Class:  GraphExReader
 *  Description:  This reader is for creating an instance of class GraphEx.
 * =====================================================================================
 */
class GraphExReader : public GraphReader
{
	public:
		/* ====================  LIFECYCLE     ======================================= */
		GraphExReader ();                             /* constructor */
		virtual ~GraphExReader (){};                             /* constructor */

		/* ====================  OPERATORS     ======================================= */

		/* ====================  OPERATIONS    ======================================= */
		// By default, the reader reads data from a file
		void SetFile (string file);
		void SetFields (int edge_from, int edge_to, int edge_ex_id);
		void SetDelimits (vector<char> delimits);
		virtual bool SetGraph (Graph* pGraph);
		virtual bool Read ();

		/* ====================  ACCESS        ======================================= */

		/* ====================  INQUIRY       ======================================= */

		/* ====================  DATA MEMBERS  ======================================= */
	protected:

	private:
		string 		mFile;
		vector<char> mDelimits;
		int    		mFieldEdgeFrom;
		int    		mFieldEdgeTo;
		int    		mFieldEdgeWeight;
		int    		mFieldEdgeExID;

}; /* -----  end of class  GraphExReader  ----- */

#endif
