/*
 * =====================================================================================
 *
 *       Filename:  DataStructures.hpp
 *
 *    Description:  Implement some basic and useful data structures
 *
 *        Version:  1.0
 *        Created:  01/13/2009 03:56:40 PM
 *       Revision:  none
 *       Compiler:  gcc
 *
 *         Author:  Jianxing Feng (feeldead), feeldead@gmail.com
 *        Company:  THU
 *
 * =====================================================================================
 */

#ifndef DataStructures_h
#define DataStructures_h

#include "BinaryHeap.h"

using namespace std;

template < typename KEY_TYPE, typename VALUE_TYPE >
class HeapKeyValue{
public:

	/*
	 * Default constructor
	 */
	HeapKeyValue():mHeapPtr(0){}

	/*
	 * This function is going to be called by BinaryHeap
	 */
	HeapKeyValue<KEY_TYPE, VALUE_TYPE>** 
	heap_ptr() const
	{
		return mHeapPtr;
	}

	/*
	 * This function is going to be called by BinaryHeap
	 */
	HeapKeyValue<KEY_TYPE, VALUE_TYPE>**&
	heap_ptr()
	{
		return mHeapPtr;
	}

	/*
	 * This function is going to be called by BinaryHeap
	 */
	void
	set_heap_ptr(HeapKeyValue<KEY_TYPE, VALUE_TYPE>** p)
	{
		mHeapPtr = p;
	}

	KEY_TYPE mKey;
	VALUE_TYPE mValue;

private:
	HeapKeyValue<KEY_TYPE, VALUE_TYPE>** mHeapPtr;
};

//! Less than compare vertices by distance.
template <typename CompType>
class EleCompare
  : public std::binary_function<CompType, CompType, bool> {
public:
  //! Less than compare vertices by distance.
  bool 
  operator()(const CompType& x, const CompType& y) const { 
    return (x->mKey < y->mKey);
  }
};

#endif
